/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfyu.meadow.registry.DamageSourceRegistry;
import net.satisfyu.meadow.registry.TagRegistry;
import net.satisfyu.meadow.util.MathUtils;
import org.jetbrains.annotations.Nullable;

public class StoveTilesFurnaceBlock
extends Block {
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0)});
    public static final VoxelShape SHAPE_BIG = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final VoxelShape SHAPE_SMALL = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0));
    private final boolean isBig;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public StoveTilesFurnaceBlock(BlockBehaviour.Properties settings, boolean isBig) {
        super(settings);
        this.isBig = isBig;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.isBig ? SHAPE_BIG : SHAPE_SMALL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    protected InteractionResult tryLightUpByPlayerHand(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        InteractionResult actionResult = InteractionResult.PASS;
        ItemStack stackHand = player.m_21120_(hand);
        if (stackHand.m_41720_() instanceof FlintAndSteelItem) {
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
            stackHand.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
            actionResult = InteractionResult.SUCCESS;
        } else if (stackHand.m_41720_() instanceof FireChargeItem) {
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
            if (!player.m_7500_()) {
                stackHand.m_41774_(1);
            }
            actionResult = InteractionResult.SUCCESS;
        }
        if (actionResult.m_19077_()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.TRUE), 11);
        }
        return actionResult;
    }

    protected InteractionResult tryExtinguishByPlayerHand(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stackHand = player.m_21120_(hand);
        Item usedItem = stackHand.m_41720_();
        if (!stackHand.m_204117_(TagRegistry.SHOVEL) && usedItem != Items.f_42447_) {
            return InteractionResult.PASS;
        }
        this.extinguish(state, world, pos);
        if (!player.m_7500_() && usedItem == Items.f_42447_) {
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity livingEntity;
        boolean isLit = (Boolean)world.m_8055_(pos).m_61143_((Property)LIT);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(livingEntity = (LivingEntity)entity))) {
            entity.m_6469_(DamageSourceRegistry.COBBLESTONE_FURNACE_BLOCK, 1.0f);
        }
        super.m_141947_(world, pos, state, entity);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double d = (double)pos.m_123341_() + 0.5;
        double e = (double)pos.m_123342_() + 0.24;
        double f = (double)pos.m_123343_() + 0.5;
        if (random.m_188500_() < 0.1) {
            world.m_7785_(d, e, f, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Direction.Axis axis = direction.m_122434_();
        double h = random.m_188500_() * 0.6 - 0.3;
        double i = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : h;
        double j = random.m_188500_() * 6.0 / 16.0;
        double k = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : h;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
    }

    private void extinguish(BlockState state, Level world, BlockPos pos) {
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        double dx = (double)pos.m_123341_() + 0.5;
        double dy = pos.m_123342_();
        double dz = (double)pos.m_123343_() + 0.5;
        world.m_7785_(dx, dy, dz, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f, false);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.meadow.stove.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

